"use client"

import { useState } from "react"
import { Button } from "@/components/ui/button"
import { Sheet, SheetContent, SheetHeader, SheetTitle, SheetTrigger } from "@/components/ui/sheet"
import { Filter, SlidersHorizontal } from "lucide-react"
import { MovieFilters } from "./movie-filters"
import { TVFilters } from "./tv-filters"
import { QuickFilters } from "./quick-filters"

interface MobileFilterToggleProps {
  type: "movie" | "tv"
}

export function MobileFilterToggle({ type }: MobileFilterToggleProps) {
  const [open, setOpen] = useState(false)

  return (
    <div className="lg:hidden">
      <Sheet open={open} onOpenChange={setOpen}>
        <SheetTrigger asChild>
          <Button variant="outline" className="bg-transparent">
            <Filter className="h-4 w-4 mr-2" />
            Filters
          </Button>
        </SheetTrigger>
        <SheetContent side="left" className="w-80 overflow-y-auto">
          <SheetHeader>
            <SheetTitle className="flex items-center gap-2">
              <SlidersHorizontal className="h-5 w-5" />
              Filters & Sort
            </SheetTitle>
          </SheetHeader>
          <div className="mt-6 space-y-6">
            <QuickFilters type={type} />
            <div className="border-t pt-6">{type === "movie" ? <MovieFilters /> : <TVFilters />}</div>
          </div>
        </SheetContent>
      </Sheet>
    </div>
  )
}
