import { redirect } from "next/navigation"
import { createServerClient } from "@/lib/supabase"
import { Header } from "@/components/header"
import { UserProfile } from "@/components/user-profile"
import { UserFavorites } from "@/components/user-favorites"
import { UserWatchlist } from "@/components/user-watchlist"
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs"

export default async function ProfilePage() {
  const supabase = createServerClient()

  try {
    const {
      data: { session },
    } = await supabase.auth.getSession()

    if (!session) {
      redirect("/login")
    }

    return (
      <div className="min-h-screen bg-background">
        <Header />

        <div className="container mx-auto px-4 py-8">
          <div className="max-w-4xl mx-auto">
            <div className="mb-8">
              <h1 className="text-3xl font-bold mb-2">My Profile</h1>
              <p className="text-muted-foreground">Manage your account and movie preferences</p>
            </div>

            <Tabs defaultValue="profile" className="space-y-6">
              <TabsList className="grid w-full grid-cols-3">
                <TabsTrigger value="profile">Profile</TabsTrigger>
                <TabsTrigger value="favorites">Favorites</TabsTrigger>
                <TabsTrigger value="watchlist">Watchlist</TabsTrigger>
              </TabsList>

              <TabsContent value="profile">
                <UserProfile user={session.user} />
              </TabsContent>

              <TabsContent value="favorites">
                <UserFavorites userId={session.user.id} />
              </TabsContent>

              <TabsContent value="watchlist">
                <UserWatchlist userId={session.user.id} />
              </TabsContent>
            </Tabs>
          </div>
        </div>
      </div>
    )
  } catch (error) {
    redirect("/login")
  }
}

export const metadata = {
  title: "Profile - MoviesWeb",
  description: "Manage your profile and movie preferences",
}
