import { redirect } from "next/navigation"
import { createServerClient } from "@/lib/supabase"
import { AdminDashboard } from "@/components/admin-dashboard"
import { AdminSetupNotice } from "@/components/admin-setup-notice"
import { Header } from "@/components/header"

export default async function AdminPage() {
  const supabase = createServerClient()
  let isAdmin = false
  let user = null

  try {
    const {
      data: { session },
    } = await supabase.auth.getSession()

    if (!session) {
      redirect("/admin/login")
    }

    user = session.user

    // Check if user is admin
    const { data: profile } = await supabase.from("profiles").select("role").eq("id", session.user.id).single()

    if (profile?.role === "admin") {
      isAdmin = true
    }
  } catch (error) {
    // If Supabase is not configured, show setup notice
    console.log("Supabase not configured, showing setup notice")
  }

  return (
    <div className="min-h-screen bg-background">
      <Header />
      <div className="container mx-auto px-4 py-8">
        {isAdmin ? (
          <AdminDashboard />
        ) : (
          <div className="space-y-6">
            <div>
              <h1 className="text-3xl font-bold">Admin Panel Access</h1>
              <p className="text-muted-foreground">
                {user
                  ? "Your account needs admin privileges to access this panel."
                  : "Please sign in with admin credentials."}
              </p>
            </div>
            <AdminSetupNotice />
          </div>
        )}
      </div>
    </div>
  )
}
