"use client"

import Link from "next/link"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Badge } from "@/components/ui/badge"
import { Lock, LogIn, UserPlus, Shield } from "lucide-react"

interface LoginRequiredOverlayProps {
  title: string
  type?: "movie" | "tv" | "episode"
  description?: string
}

export function LoginRequiredOverlay({ title, type = "movie", description }: LoginRequiredOverlayProps) {
  return (
    <div className="min-h-[60vh] flex items-center justify-center p-4">
      <Card className="w-full max-w-md border-red-200 bg-red-50 dark:border-red-800 dark:bg-red-950">
        <CardHeader className="text-center">
          <div className="mx-auto mb-4 flex h-16 w-16 items-center justify-center rounded-full bg-red-100 dark:bg-red-900">
            <Lock className="h-8 w-8 text-red-600" />
          </div>
          <CardTitle className="text-red-800 dark:text-red-200">Login Required</CardTitle>
          <CardDescription className="text-red-700 dark:text-red-300">
            This content is restricted to registered users only.
          </CardDescription>
        </CardHeader>
        <CardContent className="space-y-4 text-center">
          <div className="space-y-2">
            <Badge variant="outline" className="border-red-300 text-red-700 dark:border-red-700 dark:text-red-300">
              <Shield className="h-3 w-3 mr-1" />
              Restricted Content
            </Badge>
            <h3 className="font-semibold text-red-800 dark:text-red-200">{title}</h3>
            {description && <p className="text-sm text-red-700 dark:text-red-300">{description}</p>}
          </div>

          <div className="bg-red-100 dark:bg-red-900 p-4 rounded-lg">
            <p className="text-sm text-red-700 dark:text-red-300 mb-3">
              To access this {type} and other mature content, please sign in to your account or create a new one.
            </p>
          </div>

          <div className="flex flex-col sm:flex-row gap-3">
            <Button asChild className="bg-red-600 hover:bg-red-700 text-white">
              <Link href="/login">
                <LogIn className="h-4 w-4 mr-2" />
                Sign In
              </Link>
            </Button>
            <Button
              variant="outline"
              asChild
              className="border-red-300 text-red-700 hover:bg-red-100 dark:border-red-700 dark:text-red-300 dark:hover:bg-red-900 bg-transparent"
            >
              <Link href="/signup">
                <UserPlus className="h-4 w-4 mr-2" />
                Sign Up
              </Link>
            </Button>
          </div>

          <p className="text-xs text-red-600 dark:text-red-400">
            By signing up, you confirm that you are 18 years or older.
          </p>
        </CardContent>
      </Card>
    </div>
  )
}
