import { Suspense } from "react"
import { Header } from "@/components/header"
import { BlogPostList } from "@/components/blog-post-list"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { BookOpen, TrendingUp, Calendar, Users } from "lucide-react"

export const metadata = {
  title: "MoviesWeb Blog",
  description: "Stay updated with the latest movie news, reviews, and entertainment insights on the MoviesWeb blog.",
}

export default function BlogPage() {
  return (
    <div className="min-h-screen bg-background">
      <Header />

      <div className="container mx-auto px-4 py-12">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-12">
            <div className="flex items-center justify-center mb-6">
              <BookOpen className="h-12 w-12 text-primary mr-4" />
              <h1 className="text-4xl font-bold">MoviesWeb Blog</h1>
            </div>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
              Stay updated with the latest movie news, trending content, and entertainment insights from our AI-powered
              blog.
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mb-12">
            <Card className="text-center">
              <CardHeader>
                <TrendingUp className="h-8 w-8 text-primary mx-auto mb-2" />
                <CardTitle>Trending Topics</CardTitle>
              </CardHeader>
              <CardContent>
                <CardDescription>
                  Discover what's hot in the entertainment world with our trending movie and TV show discussions.
                </CardDescription>
              </CardContent>
            </Card>

            <Card className="text-center">
              <CardHeader>
                <Calendar className="h-8 w-8 text-primary mx-auto mb-2" />
                <CardTitle>Latest Updates</CardTitle>
              </CardHeader>
              <CardContent>
                <CardDescription>
                  Get the freshest content with regular updates about new releases and industry news.
                </CardDescription>
              </CardContent>
            </Card>

            <Card className="text-center">
              <CardHeader>
                <Users className="h-8 w-8 text-primary mx-auto mb-2" />
                <CardTitle>Community Insights</CardTitle>
              </CardHeader>
              <CardContent>
                <CardDescription>
                  Read engaging articles that reflect what the movie community is talking about.
                </CardDescription>
              </CardContent>
            </Card>
          </div>

          <div className="mb-8">
            <div className="flex flex-wrap gap-2 justify-center">
              <Badge variant="secondary">Movie Reviews</Badge>
              <Badge variant="secondary">TV Show Analysis</Badge>
              <Badge variant="secondary">Industry News</Badge>
              <Badge variant="secondary">Trending Now</Badge>
              <Badge variant="secondary">Upcoming Releases</Badge>
              <Badge variant="secondary">Behind the Scenes</Badge>
            </div>
          </div>

          <Suspense
            fallback={
              <div className="text-center py-12">
                <div className="animate-spin rounded-full h-8 w-8 border-b-2 border-primary mx-auto"></div>
                <p className="mt-4 text-muted-foreground">Loading blog posts...</p>
              </div>
            }
          >
            <BlogPostList />
          </Suspense>
        </div>
      </div>
    </div>
  )
}
